#!/bin/sh

function delete_sdb_workaround_service(){
	IFS=$'\n'
	target_to_delete="sdb-workaround*"
	a=$(find /usr/lib/systemd/system/ -name $target_to_delete)
	
	## remove service files
	for name in $a; do
		if [ -f "$name" ]; then
			echo "service to delete = $(basename $name)"
			mount -o remount,rw /
			rm $name
			if [ ! -f "$name" ]; then
				echo "success..."
			else
				echo "fail..."
			fi
		fi
	done
	
	## reboot
	if [ ! -z "$a" ]; then
		reboot -f
	fi
}

delete_sdb_workaround_service
